/*
 * Decompiled with CFR 0.152.
 */
package crm;

import crm.DiaryController;
import fastx.FastX;
import fastx.ctDateTime;
import freelance.cApplet;
import freelance.cBrowseForm;
import freelance.cControl;
import freelance.cForm;
import freelance.cUniEval;
import freelance.cWFXForm;
import graphix.Style;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import swinglance.FocusHandler;
import swinglance.Validator;

public class Diary
extends JScrollPane
implements cControl,
DiaryController {
    public DiaryPane diaryPane = this.createDiaryPane();
    public DiaryHeader diaryHeader;
    protected boolean _ignoreModify;
    protected boolean _modify;
    public boolean isCalendar = true;
    public boolean checkCurrentDay = true;
    private DiaryController controller;
    public DiaryItem activeItem;

    public Diary() {
        this.getViewport().setView(this.diaryPane);
        this.diaryHeader = this.createDiaryHeader();
        this.setColumnHeaderView(this.diaryHeader);
        this.controller = this;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JScrollBar jScrollBar = Diary.this.getVerticalScrollBar();
                jScrollBar.setValue(jScrollBar.getMaximum() / 3);
            }
        });
    }

    protected DiaryPane createDiaryPane() {
        return new DiaryPane(this);
    }

    protected DiaryHeader createDiaryHeader() {
        return new DiaryHeader(this.diaryPane);
    }

    public Diary(cForm cForm2, int n, int n2, int n3, int n4) {
        this();
        this.addFocusListener((FocusListener)new FocusHandler((Component)this, (Validator)cUniEval.getForm((Component)cForm2)));
        if (cForm2 instanceof cBrowseForm) {
            ((cBrowseForm)cForm2).tbPane.add((Component)this);
        } else {
            cForm2.getContentPane().add(this);
        }
        this.setLocation(n, n2);
        this.setSize(n3, n4);
    }

    public void readProperties(FastX fastX) {
        cWFXForm cWFXForm2 = cWFXForm.formToEmbed;
        this.addFocusListener((FocusListener)new FocusHandler((Component)this.diaryPane, (Validator)cWFXForm2));
    }

    public boolean inWeekRange(ctDateTime ctDateTime2) {
        return this.diaryPane.BEGIN.daysBefore(ctDateTime2) >= 0L && ctDateTime2.daysBefore(this.diaryPane.END) > 0L;
    }

    public ctDateTime[] weekRange(ctDateTime ctDateTime2) {
        ctDateTime ctDateTime3 = new ctDateTime(ctDateTime2);
        if (ctDateTime2.weekDay() == 1) {
            ctDateTime3.addDays(-6);
        } else if (ctDateTime2.weekDay() > 2) {
            ctDateTime3.addDays(2 - ctDateTime2.weekDay());
        }
        ctDateTime3.clearTime();
        ctDateTime ctDateTime4 = new ctDateTime(ctDateTime3);
        ctDateTime4.addDays(7);
        return new ctDateTime[]{ctDateTime3, ctDateTime4};
    }

    public boolean modified() {
        return this._modify;
    }

    public void clearModify() {
        this._modify = false;
    }

    public void setTextDirect(String string) {
        this.diaryPane.setDate(new ctDateTime(string));
    }

    public void setText(String string) {
        this.diaryPane.setDate(new ctDateTime(string));
    }

    public String getText() {
        return this.diaryPane.DATE.toString();
    }

    public boolean onValidate() {
        return true;
    }

    public boolean isNotNull() {
        return true;
    }

    public DiaryItem addItem() {
        return this.controller.DiaryCreateItem(this);
    }

    public Component self() {
        return this;
    }

    public void openRelation() {
    }

    public void onDestroy() {
    }

    public void modify() {
        if (this._ignoreModify) {
            return;
        }
        this._modify = true;
        cForm.modify((cControl)this);
    }

    public DiaryItem[] getItems() {
        Component[] componentArray = this.diaryPane.getComponents();
        if (componentArray == null || componentArray.length == 0) {
            return null;
        }
        DiaryItem[] diaryItemArray = new DiaryItem[componentArray.length];
        for (int i = 0; i < componentArray.length; ++i) {
            diaryItemArray[i] = (DiaryItem)componentArray[i];
        }
        return diaryItemArray;
    }

    public DiaryItem DiaryCreateItem(Diary diary) {
        return new DiaryItem(diary);
    }

    public boolean DiaryLoadView(Diary diary, ctDateTime ctDateTime2) {
        this.setDate(ctDateTime2);
        return true;
    }

    public String DiarySaveString(Diary diary) {
        return "";
    }

    public void DiaryOnActivateItem(DiaryItem diaryItem) {
    }

    public boolean DiaryOnDeactivateItem(DiaryItem diaryItem) {
        return true;
    }

    public boolean loadView(ctDateTime ctDateTime2) {
        if (!this.deactivateItem()) {
            return false;
        }
        this._ignoreModify = true;
        this.diaryPane.removeAll();
        this.setDate(ctDateTime2);
        boolean bl = this.controller.DiaryLoadView(this, ctDateTime2);
        this._ignoreModify = false;
        Component[] componentArray = this.diaryPane.getComponents();
        return bl;
    }

    public String getSaveString() {
        DiaryItem diaryItem = this.activeItem;
        if (!this.deactivateItem()) {
            cForm.savingOk = false;
            return null;
        }
        if (diaryItem != null) {
            this.activateItem(diaryItem);
        }
        return this.controller.DiarySaveString(this);
    }

    public boolean saveFormToItem() {
        DiaryItem diaryItem = this.activeItem;
        if (!this.deactivateItem()) {
            return false;
        }
        this.activateItem(diaryItem);
        return true;
    }

    public boolean deactivateItem() {
        if (this.activeItem != null) {
            boolean bl = this.controller.DiaryOnDeactivateItem(this.activeItem);
            if (!bl) {
                return false;
            }
            DiaryItem diaryItem = this.activeItem;
            this.activeItem = null;
            diaryItem.invalidate();
            diaryItem.repaint();
            this.diaryPane.diary.invalidate();
            this.diaryPane.diary.repaint();
            return bl;
        }
        return true;
    }

    public void reActivateItem(DiaryItem diaryItem) {
        if (this.activeItem == diaryItem) {
            this.activeItem = null;
        }
        this.activateItem(diaryItem);
    }

    public void activateItem(DiaryItem diaryItem) {
        if (this.activeItem == diaryItem) {
            return;
        }
        if (!this.deactivateItem()) {
            return;
        }
        this.controller.DiaryOnActivateItem(diaryItem);
        this.activeItem = diaryItem;
        diaryItem.invalidate();
        diaryItem.repaint();
        this.diaryPane.diary.invalidate();
        this.diaryPane.diary.repaint();
    }

    public void setController(DiaryController diaryController) {
        this.controller = diaryController != null ? diaryController : this;
    }

    public void setDate(ctDateTime ctDateTime2) {
        this.diaryPane.setDate(ctDateTime2);
        if (this.diaryHeader != null) {
            this.diaryHeader.repaint();
        }
    }

    public static class DiaryPane
    extends JPanel
    implements MouseListener {
        public ctDateTime DATE;
        public ctDateTime BEGIN;
        public ctDateTime END;
        public Diary diary;
        public DiaryItem replaned;
        public static final Color LINECOLOR = new Color(128, 128, 160);
        public static final Color LINECOLOR2 = new Color(160, 160, 192);
        public int DW = 70;
        public int HH = 40;
        public int LEFT = 4;
        public Point ORIGIN = new Point(this.LEFT + this.DW, 0);
        public Dimension SQUARE = new Dimension(this.DW, this.HH);
        public Color CURRENTDAY = new Color(232, 240, 255);

        public DiaryPane(Diary diary) {
            this.setSize(this.LEFT + 7 * this.DW, 24 * this.HH);
            this.diary = diary;
            Dimension dimension = new Dimension(this.LEFT + 8 * this.DW, 24 * this.HH);
            this.setPreferredSize(dimension);
            this.setMinimumSize(dimension);
            this.setMaximumSize(dimension);
            this.setFont(cApplet.instance().getFont());
            this.setLayout(null);
            this.setDate(null);
            this.addMouseListener(this);
        }

        public void updateORIGIN() {
            this.ORIGIN.x = this.LEFT + this.DW;
            this.ORIGIN.y = 0;
            Dimension dimension = new Dimension(this.LEFT + 8 * this.DW, 24 * this.HH);
            this.setPreferredSize(dimension);
            this.setMinimumSize(dimension);
            this.setMaximumSize(dimension);
        }

        public Point getOrigin() {
            return this.ORIGIN;
        }

        public Rectangle getSquare(DiaryItem diaryItem) {
            ctDateTime ctDateTime2 = diaryItem.FROM;
            ctDateTime ctDateTime3 = diaryItem.TO;
            ctDateTime ctDateTime4 = new ctDateTime(ctDateTime2);
            ctDateTime4.clearTime();
            if (ctDateTime2 == null) {
                return null;
            }
            if (ctDateTime3 == null) {
                ctDateTime3 = new ctDateTime(ctDateTime2).addTime(1, 0, 0);
            }
            if (ctDateTime3.daysBefore(ctDateTime2) > 0L) {
                return null;
            }
            if (ctDateTime2.daysBefore(ctDateTime3) > 0L) {
                return null;
            }
            if (this.diary.checkCurrentDay && ctDateTime4.daysBefore(this.BEGIN) > 0L) {
                return null;
            }
            if (this.diary.checkCurrentDay && this.END.daysBefore(ctDateTime4) >= 0L) {
                return null;
            }
            int n = this.getHeight() - this.ORIGIN.y;
            int n2 = (int)this.BEGIN.daysBefore(ctDateTime2) * this.DW + this.ORIGIN.x;
            int n3 = (60 * ctDateTime2.hour() + ctDateTime2.minute()) * n / 1440 + this.ORIGIN.y;
            int n4 = (60 * ctDateTime3.hour() + ctDateTime3.minute()) * n / 1440 + this.ORIGIN.y;
            if (n4 < n3) {
                return null;
            }
            return new Rectangle(n2 + 2, n3, this.DW - 3, n4 - n3 + 1);
        }

        public Dimension getSquare() {
            return this.SQUARE;
        }

        public int HEIGHT() {
            return this.getSize().height - this.ORIGIN.y;
        }

        public void setDate(ctDateTime ctDateTime2) {
            Component[] componentArray;
            ctDateTime ctDateTime3 = this.BEGIN;
            this.DATE = ctDateTime2 != null ? ctDateTime2 : ctDateTime.today();
            ctDateTime[] ctDateTimeArray = this.diary.weekRange(this.DATE);
            this.BEGIN = ctDateTimeArray[0];
            this.END = ctDateTimeArray[1];
            if ((ctDateTime3 == null || ctDateTime3.daysBefore(this.BEGIN) > 0L || this.BEGIN.daysBefore(ctDateTime3) > 0L) && (componentArray = this.getComponents()) != null) {
                for (int i = 0; i < componentArray.length; ++i) {
                    ((DiaryItem)componentArray[i]).settle();
                }
            }
            this.repaint();
        }

        protected void paintComponent(Graphics graphics) {
            int n;
            int n2;
            ctDateTime ctDateTime2 = ctDateTime.today();
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(Color.BLACK);
            if (this.BEGIN == null) {
                this.BEGIN = ctDateTime.today();
            }
            int n3 = this.getHeight();
            int n4 = this.getWidth();
            int n5 = 4;
            int n6 = this.LEFT + 4;
            for (n2 = 1; n2 < 24; ++n2) {
                graphics.drawString("" + n2 + ":00", n6, n5 + n2 * this.HH);
            }
            n2 = (int)this.BEGIN.daysBefore(ctDateTime2);
            if (n2 >= 0 && n2 < 7 && this.diary.isCalendar) {
                graphics.setColor(this.CURRENTDAY);
                graphics.fillRect(this.LEFT + ++n2 * this.DW, 0, this.DW, n3);
            }
            graphics.setColor(LINECOLOR);
            for (n = 1; n < 24; ++n) {
                graphics.drawLine(this.LEFT + this.DW, n * this.HH, n4, n * this.HH);
            }
            for (n = 1; n < 9; ++n) {
                graphics.drawLine(this.LEFT + n * this.DW, 0, this.LEFT + n * this.DW, n3);
            }
            graphics.drawLine(this.LEFT + this.DW, n3, n4, n3);
            graphics.drawLine(this.LEFT + this.DW, 0, this.LEFT + this.DW, n3);
            graphics.setColor(LINECOLOR2);
            n5 = this.HH / 2;
            for (n = 0; n < 24; ++n) {
                graphics.drawLine(this.LEFT + this.DW + 2, n5 + n * this.HH, n4, n5 + n * this.HH);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        protected DiaryItem createItemAt(int n, int n2, DiaryItem diaryItem) {
            DiaryItem diaryItem2;
            if (!this.diary.deactivateItem()) {
                return null;
            }
            int n3 = this.HEIGHT();
            int n4 = 1440 * n2 / n3;
            n4 = n4 / 5 * 5;
            int n5 = (n - this.ORIGIN.x) / this.DW;
            if (n5 >= 7 && this.diary.isCalendar) {
                return null;
            }
            if (this.replaned != null) {
                diaryItem2 = diaryItem == null ? this.replaned : this.diary.addItem();
                this.remove(this.replaned);
                this.add((Component)diaryItem2, 0);
                this.replaned = null;
                this.diary.activeItem = null;
            } else {
                diaryItem2 = this.diary.addItem();
            }
            ctDateTime ctDateTime2 = new ctDateTime(this.BEGIN).addDays(n5);
            ctDateTime2.addTime(0, n4, 0);
            diaryItem2.FROM = ctDateTime2;
            ctDateTime2 = new ctDateTime(ctDateTime2);
            ctDateTime2.addTime(1, 0, 0);
            diaryItem2.TO = ctDateTime2;
            diaryItem2.settle();
            diaryItem2.timeFromSize();
            diaryItem2.settle();
            this.diary.activateItem(diaryItem2);
            return diaryItem2;
        }

        public DiaryItem itemAtPoint(int n, int n2) {
            Component[] componentArray = this.getComponents();
            if (componentArray != null) {
                for (int i = 0; i < componentArray.length; ++i) {
                    Rectangle rectangle = componentArray[i].getBounds();
                    if (n < rectangle.x || n2 < rectangle.y || n >= rectangle.x + rectangle.width || n2 >= rectangle.y + rectangle.height) continue;
                    return (DiaryItem)componentArray[i];
                }
            }
            return null;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() > 1) {
                this.createItemAt(mouseEvent.getX(), mouseEvent.getY(), null);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.mouseReleased(mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseReleased(int n, int n2) {
            if (DiaryItem.draggedItem != null && DiaryItem.draggedItem.dragRight) {
                if (this.itemAtPoint(n, n2) != null) {
                    return;
                }
                final DiaryItem diaryItem = DiaryItem.draggedItem;
                DiaryItem diaryItem2 = this.createItemAt(n, n2, DiaryItem.draggedItem);
                if (diaryItem2 != null) {
                    diaryItem2.readFrom(DiaryItem.draggedItem);
                    this.diary.reActivateItem(diaryItem2);
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    JMenuItem jMenuItem = new JMenuItem("Kop\u00edrovat polo\u017eku");
                    jPopupMenu.add(jMenuItem);
                    jMenuItem = new JMenuItem("P\u0159esunout polo\u017eku");
                    jPopupMenu.add(jMenuItem);
                    jMenuItem.addActionListener(new AbstractAction(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            diaryItem.deleted = true;
                        }
                    });
                    jPopupMenu.show(this, n, n2);
                }
            }
            DiaryItem.draggedItem = null;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }

    public static class DiaryItem
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        public DiaryPane diaryPane;
        public ctDateTime FROM;
        public ctDateTime TO;
        public Color TITLECOLOR2 = new Color(192, 192, 255);
        public Color TITLECOLOR = new Color(248, 248, 255);
        public Font TITLEFONT;
        public int timeUnit = 0;
        public int timeMin;
        public boolean deleted;
        public HashMap properties = new HashMap();
        public String propList;
        public Color COLOR = new Color(224, 224, 255);
        public Color COLOR2 = new Color(255, 255, 255);
        public static Color belongsColor = new Color(0, 0, 255);
        public static Color bgColor = new Color(255, 255, 255, 128);
        public static Color bgColorSel = new Color(255, 255, 0, 128);
        public static Color bgColorBelongs = new Color(192, 192, 255, 128);
        public static Color bgColorDel = new Color(160, 160, 160, 128);
        protected boolean drag;
        protected boolean dragto;
        protected boolean dragRight;
        protected static DiaryItem draggedItem;
        private int omy;

        public DiaryItem(Diary diary) {
            this.diaryPane = diary.diaryPane;
            Font font = cApplet.instance().getFont();
            this.setFont(new Font(font.getName(), 0, 11));
            this.TITLEFONT = new Font(font.getName(), 1, 11);
            this.FROM = ctDateTime.now();
            this.TO = new ctDateTime(this.FROM).addTime(1, 0, 0);
            this.diaryPane.add((Component)this, 0);
            this.setVisible(true);
            this.setPreferredSize(this.diaryPane.getSquare());
            this.setMinimumSize(this.diaryPane.getSquare());
            this.settle();
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        public void settle() {
            Rectangle rectangle;
            int n = (int)this.FROM.secondsBefore(this.TO);
            if (n < 1800) {
                this.TO.addTime(0, 0, 1800 - n);
            }
            if ((rectangle = this.diaryPane.getSquare(this)) == null) {
                this.setSize(0, 0);
                this.setLocation(0, 0);
                return;
            }
            this.diaryPane.diary.modify();
            this.setSize(rectangle.width, rectangle.height);
            this.setLocation(rectangle.x, rectangle.y);
        }

        public boolean belongsTo(DiaryItem diaryItem) {
            return false;
        }

        public String get(String string) {
            return cApplet.defStr((String)((String)this.properties.get(string)));
        }

        public void put(String string, String string2) {
            this.properties.put(string, string2);
        }

        public void writeToForm(cUniEval cUniEval2) {
            String[] stringArray = cApplet.strTokenize((String)this.propList, (String)",");
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    cUniEval2.setText(stringArray[i], this.get(stringArray[i]));
                }
            }
        }

        public void clearForm(cUniEval cUniEval2) {
            String[] stringArray = cApplet.strTokenize((String)this.propList, (String)",");
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    cUniEval2.setText(stringArray[i], "");
                }
            }
        }

        public void readFromForm(cUniEval cUniEval2) {
            String[] stringArray = cApplet.strTokenize((String)this.propList, (String)",");
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.put(stringArray[i], cUniEval2.getText(stringArray[i]));
                }
            }
            this.diaryPane.diary.modify();
            this.repaint();
        }

        public void readFrom(DiaryItem diaryItem) {
            String[] stringArray = cApplet.strTokenize((String)this.propList, (String)",");
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.put(stringArray[i], diaryItem.get(stringArray[i]));
                }
            }
            this.diaryPane.diary.modify();
            this.repaint();
        }

        public String getSaveString(String string) {
            String[] stringArray = cApplet.strTokenize((String)this.propList, (String)",");
            String string2 = "";
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = string2 + cUniEval.par2WEB((String)(string + stringArray[i]), (String)this.get(stringArray[i]));
            }
            if (this.deleted) {
                string2 = string2 + cUniEval.par2WEB((String)(string + "_del"), (String)"A");
            }
            return string2;
        }

        protected Color getBGColor() {
            return bgColor;
        }

        protected void paintComponent(Graphics graphics) {
            boolean bl;
            int n = this.getWidth();
            int n2 = this.getHeight();
            DiaryItem diaryItem = this.diaryPane.diary.activeItem;
            boolean bl2 = bl = diaryItem != null && diaryItem.belongsTo(this);
            if (this.deleted) {
                graphics.setColor(bgColorDel);
            } else if (diaryItem == this) {
                graphics.setColor(bgColorSel);
            } else if (bl) {
                graphics.setColor(bgColorBelongs);
            } else {
                graphics.setColor(this.getBGColor());
            }
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(this.TITLECOLOR);
            Style.gradientRect((Graphics2D)((Graphics2D)graphics), (int)0, (int)0, (int)this.getWidth(), (int)16, (Color)this.TITLECOLOR, (Color)this.TITLECOLOR2, (int)-2);
            if (diaryItem == this) {
                graphics.setColor(Color.red);
            } else if (bl) {
                graphics.setColor(belongsColor);
            } else {
                graphics.setColor(Color.black);
            }
            graphics.drawRoundRect(0, 0, this.getWidth() - 1, n2 - 1, 2, 2);
            graphics.setColor(Color.BLACK);
            this.paintItem(graphics, 17);
            graphics.setColor(Color.BLACK);
            String string = Integer.toString(this.FROM.minute());
            if (string.length() == 1) {
                string = "0" + string;
            }
            graphics.setFont(this.TITLEFONT);
            graphics.drawString(this.FROM.hour() + ":" + string + this.getSubtitle(), 3, 12);
        }

        protected String getSubtitle() {
            return "";
        }

        public void paintItem(Graphics graphics, int n) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = mouseEvent.getY();
            this.dragRight = cUniEval.rClk((MouseEvent)mouseEvent);
            draggedItem = this;
            this.drag = true;
            if (this.getHeight() - n < 14) {
                this.dragto = true;
            }
            this.omy = n + this.getLocation().y;
            if (this.diaryPane.diary.activeItem == this) {
                this.diaryPane.diary.deactivateItem();
            }
            this.diaryPane.diary.activateItem(this);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.drag && this.dragRight) {
                Point point = this.getLocation();
                this.diaryPane.mouseReleased(mouseEvent.getX() + point.x, mouseEvent.getY() + point.y);
                this.dragRight = false;
                this.dragto = false;
                this.drag = false;
                draggedItem = null;
                return;
            }
            this.settle();
            this.dragRight = false;
            this.dragto = false;
            this.drag = false;
            draggedItem = null;
            this.diaryPane.diary.reActivateItem(this);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (!this.dragRight) {
                Cloneable cloneable;
                int n = mouseEvent.getY();
                if (this.dragto) {
                    if (n > 20) {
                        cloneable = this.getSize();
                        this.setSize(((Dimension)cloneable).width, ((Dimension)cloneable).height + (n += this.getLocation().y) - this.omy);
                        this.timeFromSize();
                    }
                } else {
                    cloneable = this.getLocation();
                    cloneable.y += (n += this.getLocation().y) - this.omy;
                    if (cloneable.y >= this.diaryPane.ORIGIN.y && cloneable.y + this.getSize().height < this.diaryPane.getSize().height) {
                        this.setLocation(cloneable.x, cloneable.y);
                        this.timeFromSize();
                    }
                }
                this.omy = n;
                int n2 = mouseEvent.getX() + this.getLocation().x;
                int n3 = (n2 - this.diaryPane.ORIGIN.x + this.diaryPane.DW / 2) / this.diaryPane.DW;
                ctDateTime ctDateTime2 = new ctDateTime(this.diaryPane.BEGIN);
                ctDateTime2.addDays(n3);
                int n4 = (int)this.FROM.daysBefore(ctDateTime2);
                if (n4 != 0 && ctDateTime2.daysBefore(this.diaryPane.END) >= 0L && this.diaryPane.BEGIN.daysBefore(ctDateTime2) >= 0L) {
                    this.FROM.addDays(n4);
                    this.TO.addDays(n4);
                    this.settle();
                }
            }
        }

        protected void checkTimeConstraints(int n, int n2, int n3, int n4) {
            if ((n != 0 || n2 != 0) && this.diaryPane.BEGIN.secondsBefore(this.FROM) < (long)(n * 3600 + n2 * 60)) {
                int n5 = (int)this.FROM.secondsBefore(this.TO);
                this.FROM.clearTime();
                this.FROM.addTime(n, n2, 0);
                this.TO.clearTime();
                this.TO.addTime(n, n2, n5);
            }
            if (n3 != 0 || n4 != 0) {
                ctDateTime ctDateTime2 = new ctDateTime(this.diaryPane.BEGIN);
                ctDateTime2.clearTime();
                ctDateTime2.addTime(n3, n4, 0);
                for (int i = 20; ctDateTime2.secondsBefore(this.TO) > 0L && i > 0; --i) {
                    this.FROM.addTime(0, -this.timeUnit, 0);
                    this.TO.addTime(0, -this.timeUnit, 0);
                }
            }
        }

        public void timeFromSize() {
            int n = this.diaryPane.HEIGHT();
            int n2 = this.getLocation().y - this.diaryPane.ORIGIN.y;
            int n3 = 1440 * n2 / n;
            this.FROM.clearTime();
            if (n3 >= 1410) {
                n3 = 1410;
            }
            if (this.timeUnit != 0) {
                n3 = n3 / this.timeUnit * this.timeUnit;
            }
            this.FROM.addTime(0, n3, 0);
            int n4 = n3;
            n3 = 1440 * (n2 + this.getSize().height - 1) / n;
            if (n3 < 30) {
                n3 = 30;
            }
            this.TO.clearTime();
            if (this.timeUnit != 0) {
                n3 = n3 / this.timeUnit * this.timeUnit;
            }
            if (n3 - n4 < this.timeMin) {
                n3 = n4 + this.timeMin;
            }
            this.TO.addTime(0, n3, 0);
            this.diaryPane.diary.modify();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public String getSaveString() {
            return null;
        }
    }

    public static class DiaryHeader
    extends JPanel {
        protected DiaryPane diaryPane;
        private static final String[] dn = new String[]{"Po", "\u00dat", "St", "\u010ct", "P\u00e1", "So", "Ne"};

        public DiaryHeader(DiaryPane diaryPane) {
            this.diaryPane = diaryPane;
            Dimension dimension = this.getMinimumSize();
            dimension.height = 24;
            this.setLayout(null);
            this.setMinimumSize(dimension);
            this.setPreferredSize(dimension);
            this.setFont(cApplet.instance().getFont());
            Mover mover = new Mover(this.diaryPane, 1);
            this.add(mover);
            mover.setLocation(2, 2);
            mover = new Mover(this.diaryPane, 0);
            this.add(mover);
            mover.setLocation(22, 2);
        }

        protected void movePrev() {
            this.diaryPane.diary.loadView(new ctDateTime(this.diaryPane.DATE.addDays(-7)));
        }

        protected void moveNext() {
            this.diaryPane.diary.loadView(new ctDateTime(this.diaryPane.DATE.addDays(7)));
        }

        protected void paintComponent(Graphics graphics) {
            int n;
            if (this.isOpaque()) {
                graphics.setColor(Color.WHITE);
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            graphics.setColor(Color.BLACK);
            if (this.diaryPane.BEGIN == null) {
                this.diaryPane.BEGIN = ctDateTime.today();
            }
            int n2 = this.getHeight();
            int n3 = this.getWidth();
            int n4 = this.diaryPane.LEFT;
            int n5 = this.getSize().height;
            graphics.drawString("" + this.diaryPane.BEGIN.year(), 45, 17);
            ctDateTime ctDateTime2 = new ctDateTime(this.diaryPane.BEGIN);
            int n6 = this.diaryPane.DW;
            int n7 = this.diaryPane.LEFT + n6 / 5;
            for (n = 1; n <= 7; ++n) {
                graphics.drawString(dn[n - 1] + "  " + ctDateTime2.day() + "." + ctDateTime2.month() + ".", n7 + n * n6, n5 - 4);
                ctDateTime2 = ctDateTime2.addDays(1);
            }
            graphics.setColor(DiaryPane.LINECOLOR);
            for (n = 1; n < 9; ++n) {
                graphics.drawLine(n4 + n * n6, 0, n4 + n * n6, n2);
            }
            graphics.drawLine(0, n5 - 1, this.getSize().width, n5 - 1);
        }

        class Mover
        extends JButton
        implements ActionListener {
            Image image;
            static final int TYPE_NWEEK = 0;
            static final int TYPE_PWEEK = 1;
            static final int TYPE_NMONTH = 2;
            static final int TYPE_PMONTH = 3;
            static final int TYPE_NYEAR = 4;
            static final int TYPE_PYEAR = 5;
            int TYPE;

            public Mover(DiaryPane diaryPane, int n) {
                this.TYPE = n;
                DiaryHeader.this.diaryPane = diaryPane;
                this.image = n % 2 == 1 ? cApplet.instance().resImage("iPrev") : cApplet.instance().resImage("iNext");
                Dimension dimension = new Dimension(20, 20);
                this.setMinimumSize(dimension);
                this.setSize(dimension);
                this.setMaximumSize(dimension);
                this.setPreferredSize(dimension);
                this.setIcon(new ImageIcon(this.image));
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                cForm cForm2 = cUniEval.getForm((Component)DiaryHeader.this.diaryPane.diary);
                if (!cForm2.checkModifyAndSave()) {
                    return;
                }
                if (this.TYPE == 0) {
                    DiaryHeader.this.moveNext();
                } else if (this.TYPE == 1) {
                    DiaryHeader.this.movePrev();
                }
            }
        }
    }
}

