/*
 * Decompiled with CFR 0.152.
 */
package juno;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import swinglance.MainFrame;

public class PrintPane
extends JEditorPane {
    Vector history = new Vector();
    public static boolean lastPrintOk;

    public PrintPane() {
        this.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.setContentType("text/html; charset=windows-1250");
        this.setEditable(false);
        this.setEditorKit(new EditKit());
        ((HTMLEditorKit)this.getEditorKit()).createDefaultDocument();
        this.setEditorKitForContentType("text/html", this.getEditorKit());
    }

    boolean print2() {
        DocumentRenderer documentRenderer = new DocumentRenderer();
        return documentRenderer.print(this);
    }

    public static boolean print(String string) {
        lastPrintOk = true;
        new Dlg(string).setVisible(true);
        return lastPrintOk;
    }

    public static class ContainerRenderer
    implements Printable {
        protected int currentPage = -1;
        protected Container editor;
        protected double pageEndY = 0.0;
        protected double pageStartY = 0.0;
        protected boolean scaleWidthToFit = true;
        protected boolean scaleHeightToFit = true;
        protected PageFormat pFormat;
        protected PrinterJob pJob;
        protected boolean inited;
        double ew;
        double eh;
        double px;
        double py;
        double pw;
        double ph;
        double scale;

        public static boolean printContainer(Container container) {
            ContainerRenderer containerRenderer = new ContainerRenderer(container);
            return containerRenderer.printDialog(container);
        }

        public ContainerRenderer(Container container) {
            this.editor = container;
            this.pFormat = new PageFormat();
            this.inited = false;
            Paper paper = new Paper();
            paper.setSize(580.0, 820.0);
            double d = 18.0;
            paper.setImageableArea(d, d, paper.getWidth(), paper.getHeight());
            this.pFormat.setPaper(paper);
            this.pJob = PrinterJob.getPrinterJob();
        }

        public void pageDialog() {
            this.pFormat = this.pJob.pageDialog(this.pFormat);
        }

        private void init(Graphics2D graphics2D, PageFormat pageFormat) {
            this.inited = true;
            if (this.editor instanceof JComponent) {
                this.editor.invalidate();
                ((JComponent)this.editor).updateUI();
            }
            this.scale = 1.0;
            this.ew = this.editor.getSize().getWidth();
            this.eh = this.editor.getSize().getHeight();
            this.px = pageFormat.getImageableX();
            this.py = pageFormat.getImageableY();
            this.pw = pageFormat.getImageableWidth();
            this.ph = pageFormat.getImageableHeight();
            if (this.scaleWidthToFit || this.scaleHeightToFit) {
                double d;
                this.scale = this.scaleWidthToFit && this.ew > this.pw ? this.pw / this.ew : 1.0;
                if (this.scaleHeightToFit && this.eh > this.ph && (d = this.ph / this.eh) < this.scale) {
                    this.scale = d;
                }
                if (this.scale < 0.4) {
                    this.scale = 0.4;
                }
            }
        }

        public int print(Graphics graphics, PageFormat pageFormat, int n) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (!this.inited) {
                this.init(graphics2D, pageFormat);
            }
            int n2 = (int)(this.ph / this.scale);
            if (n > this.currentPage) {
                this.currentPage = n;
                this.pageStartY += this.pageEndY;
                this.pageEndY = n2;
            }
            if (this.eh - this.pageStartY > 0.0) {
                double d;
                if (this.scale != 1.0) {
                    graphics2D.scale(this.scale, this.scale);
                }
                if ((d = (this.eh - (double)(n2 * n)) * this.scale) > this.ph) {
                    d = this.ph;
                }
                graphics2D.setClip((int)(this.px / this.scale), (int)(this.py / this.scale), (int)(this.pw / this.scale), (int)(d / this.scale));
                graphics2D.translate(this.px / this.scale, this.py / this.scale - this.pageStartY);
                this.editor.paint(graphics2D);
                return 0;
            }
            this.pageStartY = 0.0;
            this.pageEndY = 0.0;
            this.currentPage = -1;
            return 1;
        }

        protected boolean printDialog(Container container) {
            this.editor = container;
            if (this.pJob.printDialog()) {
                this.pJob.setPrintable(this, this.pFormat);
                try {
                    this.pJob.print();
                    return true;
                }
                catch (PrinterException printerException) {
                    this.pageStartY = 0.0;
                    this.pageEndY = 0.0;
                    this.currentPage = -1;
                    System.out.println("Error Printing Document");
                    lastPrintOk = false;
                    return false;
                }
            }
            return false;
        }

        public boolean print(Container container) {
            this.editor = container;
            this.pJob.setPrintable(this, this.pFormat);
            try {
                this.pJob.print();
                return true;
            }
            catch (PrinterException printerException) {
                this.pageStartY = 0.0;
                this.pageEndY = 0.0;
                this.currentPage = -1;
                lastPrintOk = false;
                System.out.println("Error Printing Document");
                return false;
            }
        }

        public void setScaleWidthToFit(boolean bl) {
            this.scaleWidthToFit = bl;
        }
    }

    public static class Dlg
    extends JDialog
    implements ActionListener {
        JButton ok;
        JButton print;
        PrintPane TEXT;

        public Dlg(String string) {
            super((Frame)MainFrame.frame(), "Tisk", true);
            JPanel jPanel = new JPanel();
            JPanel jPanel2 = new JPanel();
            jPanel.setLayout(new BorderLayout());
            this.TEXT = new PrintPane();
            jPanel.add((Component)this.TEXT, "Center");
            this.TEXT.setText(string);
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            this.ok = new JButton();
            this.ok.setActionCommand("ok");
            this.ok.setText("OK");
            this.ok.addActionListener(this);
            this.print = new JButton();
            this.print.setActionCommand("print");
            this.print.setText("Tisk");
            this.print.addActionListener(this);
            jPanel2.add(this.ok);
            jPanel2.add(this.print);
            jPanel.add((Component)jPanel2, "South");
            this.setContentPane(jPanel);
            this.pack();
            this.setSize(MainFrame.frame().getSize());
            MainFrame.center((Component)this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if ("ok".equals(string)) {
                this.dispose();
            } else if ("print".equals(string)) {
                this.TEXT.print2();
                this.dispose();
            }
        }
    }

    public static class DocumentRenderer
    implements Printable {
        protected int currentPage = -1;
        protected JTextComponent editor;
        protected double pageEndY = 0.0;
        protected double pageStartY = 0.0;
        protected boolean scaleWidthToFit = true;
        protected PageFormat pFormat = new PageFormat();
        protected PrinterJob pJob = PrinterJob.getPrinterJob();

        public Document getDocument() {
            if (this.editor != null) {
                return this.editor.getDocument();
            }
            return null;
        }

        public boolean getScaleWidthToFit() {
            return this.scaleWidthToFit;
        }

        public void pageDialog() {
            this.pFormat = this.pJob.pageDialog(this.pFormat);
        }

        public int print(Graphics graphics, PageFormat pageFormat, int n) {
            double d = 1.0;
            Graphics2D graphics2D = (Graphics2D)graphics;
            this.editor.setSize((int)pageFormat.getImageableWidth(), Integer.MAX_VALUE);
            this.editor.validate();
            View view = this.editor.getUI().getRootView(this.editor);
            if (this.scaleWidthToFit && this.editor.getMinimumSize().getWidth() > pageFormat.getImageableWidth()) {
                d = pageFormat.getImageableWidth() / this.editor.getMinimumSize().getWidth();
                graphics2D.scale(d, d);
            }
            int n2 = (int)(pageFormat.getImageableHeight() / d);
            graphics2D.setClip((int)(pageFormat.getImageableX() / d), (int)(pageFormat.getImageableY() / d), (int)(pageFormat.getImageableWidth() / d), n2);
            if (n > this.currentPage) {
                this.currentPage = n;
                this.pageStartY += this.pageEndY;
                this.pageEndY = graphics2D.getClipBounds().getHeight();
            }
            graphics2D.translate(graphics2D.getClipBounds().getX(), graphics2D.getClipBounds().getY());
            Rectangle rectangle = new Rectangle(0, (int)(-this.pageStartY), (int)this.editor.getMinimumSize().getWidth(), n2);
            if (this.printView(graphics2D, rectangle, view)) {
                return 0;
            }
            this.pageStartY = 0.0;
            this.pageEndY = 0.0;
            this.currentPage = -1;
            this.editor.repaint();
            return 1;
        }

        public boolean print(JTextComponent jTextComponent) {
            this.editor = jTextComponent;
            Paper paper = new Paper();
            paper.setSize(580.0, 820.0);
            double d = 18.0;
            paper.setImageableArea(d, d, paper.getWidth(), paper.getHeight());
            this.pFormat.setPaper(paper);
            this.pJob.setPrintable(this, this.pFormat);
            try {
                this.pJob.print();
                return true;
            }
            catch (PrinterException printerException) {
                this.pageStartY = 0.0;
                this.pageEndY = 0.0;
                this.currentPage = -1;
                lastPrintOk = false;
                System.out.println("Error Printing Document");
                return false;
            }
        }

        protected boolean printView(Graphics2D graphics2D, Shape shape, View view) {
            boolean bl;
            boolean bl2 = false;
            Rectangle rectangle = graphics2D.getClipBounds();
            boolean bl3 = bl = view.getViewCount() > 0;
            if ((!bl || view.getElement().getName().equals("table")) && shape.getBounds().getMaxY() >= rectangle.getY()) {
                bl2 = true;
                if (shape.getBounds().getHeight() > rectangle.getHeight() && shape.intersects(rectangle)) {
                    view.paint(graphics2D, shape);
                } else if (shape.getBounds().getY() >= rectangle.getY()) {
                    if (shape.getBounds().getMaxY() <= rectangle.getMaxY()) {
                        view.paint(graphics2D, shape);
                    } else if (shape.getBounds().getY() < this.pageEndY) {
                        this.pageEndY = shape.getBounds().getY();
                    }
                }
            }
            if (bl) {
                for (int i = 0; i < view.getViewCount(); ++i) {
                    View view2;
                    Shape shape2 = view.getChildAllocation(i, shape);
                    if (shape2 == null || !this.printView(graphics2D, shape2, view2 = view.getView(i))) continue;
                    bl2 = true;
                }
            }
            return bl2;
        }

        public void setScaleWidthToFit(boolean bl) {
            this.scaleWidthToFit = bl;
        }
    }

    public class EditKit
    extends HTMLEditorKit {
        public Document createDefaultDocument() {
            StyleSheet styleSheet = this.getStyleSheet();
            StyleSheet styleSheet2 = new StyleSheet();
            styleSheet2.addStyleSheet(styleSheet);
            HTMLDoc hTMLDoc = new HTMLDoc(styleSheet2);
            hTMLDoc.setParser(this.getParser());
            hTMLDoc.setAsynchronousLoadPriority(4);
            return hTMLDoc;
        }
    }

    public class HTMLDoc
    extends HTMLDocument {
        public HTMLDoc(StyleSheet styleSheet) {
            super(styleSheet);
            this.getStyleSheet().addRule("body {font-family: Verdana; font-size: 12pt;}");
        }

        public void lock() {
            this.writeLock();
        }

        public void unLock() {
            this.writeUnlock();
        }
    }
}

